//+------------------------------------------------------------------+
//|                                             Trending or Ranging? |
//|                                                     ToR_1.10.mq4 |
//|                                       Copyright  2008 Tom Balfe |
//|                                                                  |
//| This indicator shows you whether a pair is trending or ranging.  | 
//| For trending markets use moving averages and for ranging         |
//| market use oscillators.                                          |
//|                                                                  |
//| Best of luck in all your trades!                                 |
//|                                                                  |
//| Version: 1.10                                                    |
//|                                                                  |
//| Changelog:                                                       |
//|     1.10 - added ADX increasing and decreasing notice            |
//|     1.03 - adjusted spacing, fonts, unreleased                   |
//|     1.02 - added arrows, ranging icon, no zero space state       |
//|            for icons/arrows, spacing got messed up, now          | 
//|            fixed                                                 |
//|     1.01 - unreleased, Reduced number of colors, functional      |
//|     1.0  - unreleased, too many colors for ADX values            |
//|                                                                  |
//|                   http://www.forex-tsd.com/members/nittany1.html |
//|     Edited by : ServerUang, 24 Januari 2008, 12:00 wib           |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007-2008 Tom Balfe"
#property link      "http://www.forex-tsd.com/members/nittany1.html"
#property link      "redcarsarasota@yahoo.com"
#property indicator_separate_window

int spread;
//---- user selectable stuff
extern int  SpreadThreshold   = 6;
extern int  ADX_Period = 12;
extern bool Show_h1_ADX       = true;
extern int  ADX_trend_level   = 23;
extern int  ADX_trend_strong  = 28;
extern bool Turn_on_Signal    = true;
extern int  Signal_from_TF    = 5;
extern string Edited_by = "ServerUang" ;

double alertBar;
double prev;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   //---- indicator short name
   IndicatorShortName("ToR 1.10 ("+Symbol()+")");

   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   //---- need to delete objects should user remove indicator
   ObjectsDeleteAll(0,OBJ_LABEL);
     ObjectDelete("ToR110-1");ObjectDelete("ToR110-2");ObjectDelete("ToR110-3");
     ObjectDelete("ToR110-4");ObjectDelete("ToR110-5");ObjectDelete("ToR110-6");
     ObjectDelete("ToR110-7");ObjectDelete("ToR110-8");ObjectDelete("ToR110-9");
     ObjectDelete("ToR110-10");ObjectDelete("ToR110-11");ObjectDelete("ToR110-12");
     ObjectDelete("ToR110-4a");ObjectDelete("ToR110-6a");ObjectDelete("ToR110-8a");
     ObjectDelete("ToR110-10a");ObjectDelete("ToR110-12a");ObjectDelete("ToR110-4b");
     ObjectDelete("ToR110-6b");ObjectDelete("ToR110-8b");ObjectDelete("ToR110-10b");
     ObjectDelete("ToR110-12b");
   return(0);
  }

int start()
  {
   //---- let's define some stuff 
   // M1 ADX data
   double adx_m1 = iADX(NULL,1,ADX_Period,PRICE_CLOSE,0,0); // ADX 1 min
   double adx_1ago_m1 = iADX(NULL,1,ADX_Period,PRICE_CLOSE,0,1); // ADX 1 min 1 bar ago
   double di_p_m1 = iADX(NULL,1,ADX_Period,PRICE_CLOSE,1,0); // DI+ 1 min
   double di_m_m1 = iADX(NULL,1,ADX_Period,PRICE_CLOSE,2,0); // DI- 1 min
   // M5 ADX data
   double adx_m5 = iADX(NULL,5,ADX_Period,PRICE_CLOSE,0,0); // ADX 5 min
   double adx_1ago_m5 = iADX(NULL,5,ADX_Period,PRICE_CLOSE,0,1); // ADX 5 min 1 bar ago
   double di_p_m5 = iADX(NULL,5,ADX_Period,PRICE_CLOSE,1,0); // DI+ 5 min
   double di_m_m5 = iADX(NULL,5,ADX_Period,PRICE_CLOSE,2,0); // DI- 5 min
   // M15 ADX data
   double adx_m15 = iADX(NULL,15,ADX_Period,PRICE_CLOSE,0,0); // ADX 15 min
   double adx_1ago_m15 = iADX(NULL,15,ADX_Period,PRICE_CLOSE,0,1); // ADX 15 min 1 bar ago
   double di_p_m15 = iADX(NULL,15,ADX_Period,PRICE_CLOSE,1,0); // DI+ 15 min
   double di_m_m15 = iADX(NULL,15,ADX_Period,PRICE_CLOSE,2,0); // DI- 15 min
   // M30 ADX data
   double adx_m30 = iADX(NULL,30,ADX_Period,PRICE_CLOSE,0,0); // ADX 30 min
   double adx_1ago_m30 = iADX(NULL,30,ADX_Period,PRICE_CLOSE,0,1); // ADX 30 min 1 bar ago
   double di_p_m30 = iADX(NULL,30,ADX_Period,PRICE_CLOSE,1,0); // DI+ 30 min
   double di_m_m30 = iADX(NULL,30,ADX_Period,PRICE_CLOSE,2,0); // DI- 30 min
   // h1 ADX data
   double adx_h1 = iADX(NULL,60,ADX_Period,PRICE_CLOSE,0,0); // ADX 1 hour
   double adx_1ago_h1 = iADX(NULL,60,ADX_Period,PRICE_CLOSE,0,1); // ADX 1 hr 1 bar ago
   double di_p_h1 = iADX(NULL,60,ADX_Period,PRICE_CLOSE,1,0); // DI+ 1 hour
   double di_m_h1 = iADX(NULL,60,ADX_Period,PRICE_CLOSE,2,0); // DI- 1 hour
   
   //---- define colors and arrows 
   color adx_color_m1,adx_color_m5,adx_color_m15,adx_color_m30,adx_color_h1,
         adx_status_m1,adx_status_m5,adx_status_m15,adx_status_m30,adx_status_h1;
         
   string  adx_arrow_m1,adx_arrow_m5,adx_arrow_m15,adx_arrow_m30,adx_arrow_h1,
           cci_symbol_m1,cci_symbol_m5,cci_symbol_m15,cci_symbol_m30;
      
   //---- assign color
   // m1 colors
   if ((adx_m1 < ADX_trend_level) && (adx_m1 != 0)) { adx_color_m1 = LightSkyBlue; }
   if ((adx_m1 >=ADX_trend_level) && (di_p_m1 > di_m_m1)) { adx_color_m1 = Lime; }
   if ((adx_m1 >=ADX_trend_level) && (di_p_m1 < di_m_m1)) { adx_color_m1 = Red; }
   if ((adx_m1 > adx_1ago_m1) && (adx_m1 != 0) && (adx_1ago_m1 != 0)) { adx_status_m1 = Lime; }
   if ((adx_m1 < adx_1ago_m1) && (adx_m1 != 0) && (adx_1ago_m1 != 0)) { adx_status_m1 = Red; }
        
   // m5 colors
   if ((adx_m5 < ADX_trend_level) && (adx_m5 != 0)) { adx_color_m5 = LightSkyBlue; }
   if ((adx_m5 >=ADX_trend_level) && (di_p_m5 > di_m_m5)) { adx_color_m5 = Lime; }
   if ((adx_m5 >=ADX_trend_level) && (di_p_m5 < di_m_m5)) { adx_color_m5 = Red; }
   if ((adx_m5 > adx_1ago_m5) && (adx_m5 != 0) && (adx_1ago_m5 != 0)) { adx_status_m5 = Lime; }
   if ((adx_m5 < adx_1ago_m5) && (adx_m5 != 0) && (adx_1ago_m5 != 0)) { adx_status_m5 = Red; }
   
   // m15 colors
   if ((adx_m15 < ADX_trend_level) && (adx_m15 != 0)) { adx_color_m15 = LightSkyBlue; }  
   if ((adx_m15 >=ADX_trend_level) && (di_p_m15 > di_m_m15)) { adx_color_m15 = Lime; }
   if ((adx_m15 >=ADX_trend_level) && (di_p_m15 < di_m_m15)) { adx_color_m15 = Red; }
   if ((adx_m15 > adx_1ago_m15) && (adx_m15 != 0) && (adx_1ago_m15 != 0)) { adx_status_m15 = Lime; }
   if ((adx_m15 < adx_1ago_m15) && (adx_m15 != 0) && (adx_1ago_m15 != 0)) { adx_status_m15 = Red; }
   
   // m30 colors
   if ((adx_m30 < ADX_trend_level) && (adx_m30 != 0)) { adx_color_m30 = LightSkyBlue; }
   if ((adx_m30 >=ADX_trend_level) && (di_p_m30 > di_m_m30)) { adx_color_m30 = Lime; }
   if ((adx_m30 >=ADX_trend_level) && (di_p_m30 < di_m_m30)) { adx_color_m30 = Red; }
   if ((adx_m30 > adx_1ago_m30) && (adx_m30 != 0) && (adx_1ago_m30 != 0)) { adx_status_m30 = Lime; }
   if ((adx_m30 < adx_1ago_m30) && (adx_m30 != 0) && (adx_1ago_m30 != 0)) { adx_status_m30 = Red; }
   
   // h1 colors 
   if ((adx_h1 < ADX_trend_level) && (adx_h1 != 0)) { adx_color_h1 = LightSkyBlue; }
   if ((adx_h1 >=ADX_trend_level) && (di_p_h1 > di_m_h1)) { adx_color_h1 = Lime; }
   if ((adx_h1 >=ADX_trend_level) && (di_p_h1 < di_m_h1)) { adx_color_h1 = Red; }
   if ((adx_h1 > adx_1ago_h1) && (adx_h1 != 0) && (adx_1ago_h1 != 0)) { adx_status_h1 = Lime; }
   if ((adx_h1 < adx_1ago_h1) && (adx_h1 != 0) && (adx_1ago_h1 != 0)) { adx_status_h1 = Red; }
   
   //---- feed all the ADX values into strings      
   string adx_value_m1 = adx_m1;
   string adx_value_m5 = adx_m5;
   string adx_value_m15 = adx_m15;
   string adx_value_m30 = adx_m30;
   string adx_value_h1 = adx_h1;
   
   //---- assign arrows strong up: { adx_arrow_ = ""; } strong down: { adx_arrow_ = ""; }
   //                   up: { adx_arrow_ = ""; } down: { adx_arrow_ = ""; }
   //                   range: { adx_arrow_ = "h"; }
   //                   use wingdings for these, the h is squiggly line
   
   // m1 arrows
   if (adx_m1 < ADX_trend_level && adx_m1 != 0) { adx_arrow_m1 = "h"; }
   if ((adx_m1 >= ADX_trend_level && adx_m1 < ADX_trend_strong) && (di_p_m1 > di_m_m1)) { adx_arrow_m1 = ""; }
   if ((adx_m1 >= ADX_trend_level && adx_m1 < ADX_trend_strong) && (di_p_m1 < di_m_m1)) { adx_arrow_m1 = ""; }
   if ((adx_m1 >=ADX_trend_strong) && (di_p_m1 > di_m_m1)) { adx_arrow_m1 = ""; }
   if ((adx_m1 >=ADX_trend_strong) && (di_p_m1 < di_m_m1)) { adx_arrow_m1 = ""; }
   
   // m5 arrows
   if (adx_m5 < ADX_trend_level && adx_m5 != 0) { adx_arrow_m5 = "h"; }
   if ((adx_m5 >= ADX_trend_level && adx_m5 < ADX_trend_strong) && (di_p_m5 > di_m_m5)) { adx_arrow_m5 = ""; }
   if ((adx_m5 >= ADX_trend_level && adx_m5 < ADX_trend_strong) && (di_p_m5 < di_m_m5)) { adx_arrow_m5 = ""; }
   if ((adx_m5 >=ADX_trend_strong) && (di_p_m5 > di_m_m5)) { adx_arrow_m5 = ""; }
   if ((adx_m5 >=ADX_trend_strong) && (di_p_m5 < di_m_m5)) { adx_arrow_m5 = ""; }

   // m15 arrows
   if (adx_m15 < ADX_trend_level && adx_m15 != 0) { adx_arrow_m15 = "h"; }
   if ((adx_m15 >= ADX_trend_level && adx_m15 < ADX_trend_strong) && (di_p_m15 > di_m_m15)) { adx_arrow_m15 = ""; }
   if ((adx_m15 >= ADX_trend_level && adx_m15 < ADX_trend_strong) && (di_p_m15 < di_m_m15)) { adx_arrow_m15 = ""; }
   if ((adx_m15 >=ADX_trend_strong) && (di_p_m15 > di_m_m15)) { adx_arrow_m15 = ""; }
   if ((adx_m15 >=ADX_trend_strong) && (di_p_m15 < di_m_m15)) { adx_arrow_m15 = ""; }
   
   // m30 arrows
   if (adx_m30 < ADX_trend_level && adx_m30 != 0) { adx_arrow_m30 = "h"; }
   if ((adx_m30 >= ADX_trend_level && adx_m30 < ADX_trend_strong) && (di_p_m30 > di_m_m30)) { adx_arrow_m30 = ""; }
   if ((adx_m30 >= ADX_trend_level && adx_m30 < ADX_trend_strong) && (di_p_m30 < di_m_m30)) { adx_arrow_m30 = ""; }
   if ((adx_m30 >=ADX_trend_strong) && (di_p_m30 > di_m_m30)) { adx_arrow_m30 = ""; }
   if ((adx_m30 >=ADX_trend_strong) && (di_p_m30 < di_m_m30)) { adx_arrow_m30 = ""; }
   
   // h1 arrows
   if (adx_h1 < ADX_trend_level && adx_h1 != 0) { adx_arrow_h1 = "h"; }
   if ((adx_h1 >= ADX_trend_level && adx_h1 < ADX_trend_strong) && (di_p_h1 > di_m_h1)) { adx_arrow_h1 = ""; }
   if ((adx_h1 >= ADX_trend_level && adx_h1 < ADX_trend_strong) && (di_p_h1 < di_m_h1)) { adx_arrow_h1 = ""; }
   if ((adx_h1 >=ADX_trend_strong) && (di_p_h1 > di_m_h1)) { adx_arrow_h1 = ""; }
   if ((adx_h1 >=ADX_trend_strong) && (di_p_h1 < di_m_h1)) { adx_arrow_h1 = ""; }

   //---- defines what spread is 
   spread=MarketInfo(Symbol(),MODE_SPREAD);
    
   //----====>>>> creates text "Current Spread: "
   ObjectCreate("ToR110-1", OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-1","Current Spread:", 10, "Lucida Sans Regular", LightSteelBlue);
     ObjectSet("ToR110-1", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-1", OBJPROP_XDISTANCE, 110);
     ObjectSet("ToR110-1", OBJPROP_YDISTANCE, 2);

//---- creates spread number, Lime if less than threshold, Red if above it
   ObjectCreate("ToR110-2", OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     if (spread<=SpreadThreshold)
     {
     ObjectSetText("ToR110-2",DoubleToStr(spread ,0),10, "Lucida Sans Regular", Lime);
     }
     else
     ObjectSetText("ToR110-2",DoubleToStr(spread ,0),10, "Lucida Sans Regular", Red);
     ObjectSet("ToR110-2", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-2", OBJPROP_XDISTANCE, 215);
     ObjectSet("ToR110-2", OBJPROP_YDISTANCE, 2);
   
   //----====>>>> ADX STUFF
   //----====>>>> creates text "1 Min: "  
   ObjectCreate("ToR110-3",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-3","1 Min:", 10, "Lucida Sans Regular", LightSteelBlue);
     ObjectSet("ToR110-3", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-3", OBJPROP_XDISTANCE, 230);
     ObjectSet("ToR110-3", OBJPROP_YDISTANCE, 2);
   //---- create 1 min value
   ObjectCreate("ToR110-4",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-4", " ADX "+StringSubstr(adx_value_m1,0,5)+" ",9, "Lucida Sans Regular",adx_color_m1);
     ObjectSet("ToR110-4", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-4", OBJPROP_XDISTANCE, 270);
     ObjectSet("ToR110-4", OBJPROP_YDISTANCE, 2);
   //---- create 1 min arrow, squiggle if ranging
   ObjectCreate("ToR110-4a",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-4a",adx_arrow_m1,9, "Wingdings",adx_color_m1);
     ObjectSet("ToR110-4a", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-4a", OBJPROP_XDISTANCE, 345);
     ObjectSet("ToR110-4a", OBJPROP_YDISTANCE, 2); 
   if (adx_m1 > adx_1ago_m1)
   {
   //---- create text "increasing, decreasing"
   ObjectCreate("ToR110-4b",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-4b", " increasing ",9, "Lucida Console",adx_status_m1);
     ObjectSet("ToR110-4b", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-4b", OBJPROP_XDISTANCE, 275);
     ObjectSet("ToR110-4b", OBJPROP_YDISTANCE, 17); 
   }   
   if (adx_m1 < adx_1ago_m1)
   {
   ObjectCreate("ToR110-4b",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-4b", " decreasing ",9, "Lucida Console",adx_status_m1);
     ObjectSet("ToR110-4b", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-4b", OBJPROP_XDISTANCE, 275);
     ObjectSet("ToR110-4b", OBJPROP_YDISTANCE, 17); 
   }
   
   //----====>>>> create text "5 Min: "
   ObjectCreate("ToR110-5",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-5","5 Min:", 10, "Lucida Sans Regular", LightSteelBlue);
     ObjectSet("ToR110-5", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-5", OBJPROP_XDISTANCE, 360);
     ObjectSet("ToR110-5", OBJPROP_YDISTANCE, 2);
   //---- create 5 min value
   ObjectCreate("ToR110-6",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-6", " ADX "+StringSubstr(adx_value_m5,0,5)+" ",9, "Lucida Sans Regular",adx_color_m5);
     ObjectSet("ToR110-6", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-6", OBJPROP_XDISTANCE, 400);
     ObjectSet("ToR110-6", OBJPROP_YDISTANCE, 2);
   //---- create 5 min arrow, squiggle if ranging
   ObjectCreate("ToR110-6a",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-6a",adx_arrow_m5,9, "Wingdings",adx_color_m5);
     ObjectSet("ToR110-6a", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-6a", OBJPROP_XDISTANCE, 475);
     ObjectSet("ToR110-6a", OBJPROP_YDISTANCE, 2); 
   if (adx_m5 > adx_1ago_m5)
   {
   //---- create text "increasing, decreasing"
   ObjectCreate("ToR110-6b",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-6b", " increasing ",9, "Lucida Console",adx_status_m5);
     ObjectSet("ToR110-6b", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-6b", OBJPROP_XDISTANCE, 405);
     ObjectSet("ToR110-6b", OBJPROP_YDISTANCE, 17); 
   }   
   if (adx_m5 < adx_1ago_m5)
   {
   ObjectCreate("ToR110-6b",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-6b", " decreasing ",9, "Lucida Console",adx_status_m5);
     ObjectSet("ToR110-6b", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-6b", OBJPROP_XDISTANCE, 405);
     ObjectSet("ToR110-6b", OBJPROP_YDISTANCE, 17); 
   }   
   
   //----====>>>> create text "15 Min: "
   ObjectCreate("ToR110-7",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-7","15 Min:", 10, "Lucida Sans Regular", LightSteelBlue);
     ObjectSet("ToR110-7", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-7", OBJPROP_XDISTANCE, 490);
     ObjectSet("ToR110-7", OBJPROP_YDISTANCE, 2);
   //---- create 15 min value
   ObjectCreate("ToR110-8",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-8", " ADX "+StringSubstr(adx_value_m15,0,5)+" ",9, "Lucida Sans Regular",adx_color_m15);
     ObjectSet("ToR110-8", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-8", OBJPROP_XDISTANCE, 535);
     ObjectSet("ToR110-8", OBJPROP_YDISTANCE, 2);
   //---- create 15 min arrow, squiggle if ranging
   ObjectCreate("ToR110-8a",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-8a",adx_arrow_m15,9, "Wingdings",adx_color_m15);
     ObjectSet("ToR110-8a", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-8a", OBJPROP_XDISTANCE, 605);
     ObjectSet("ToR110-8a", OBJPROP_YDISTANCE, 2); 
   if (adx_m15 > adx_1ago_m15)
   {
   //---- create text "increasing, decreasing"
   ObjectCreate("ToR110-8b",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-8b", " increasing ",9, "Lucida Console",adx_status_m15);
     ObjectSet("ToR110-8b", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-8b", OBJPROP_XDISTANCE, 535);
     ObjectSet("ToR110-8b", OBJPROP_YDISTANCE, 17); 
   }   
   if (adx_m15 < adx_1ago_m15)
   {
   ObjectCreate("ToR110-8b",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-8b", " decreasing ",9, "Lucida Console",adx_status_m15);
     ObjectSet("ToR110-8b", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-8b", OBJPROP_XDISTANCE, 535);
     ObjectSet("ToR110-8b", OBJPROP_YDISTANCE, 17); 
   }     

   //----====>>>> create text "30 Min: "
   ObjectCreate("ToR110-9",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-9","30 Min:", 10, "Lucida Sans Regular", LightSteelBlue);
     ObjectSet("ToR110-9", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-9", OBJPROP_XDISTANCE, 625);
     ObjectSet("ToR110-9", OBJPROP_YDISTANCE, 2);
   //---- create 30 min value
   ObjectCreate("ToR110-10",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-10", " ADX "+StringSubstr(adx_value_m30,0,5)+" ",9, "Lucida Sans Regular",adx_color_m30);
     ObjectSet("ToR110-10", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-10", OBJPROP_XDISTANCE, 670);
     ObjectSet("ToR110-10", OBJPROP_YDISTANCE, 2);
   //---- create 30 min arrow, squiggle if ranging
   ObjectCreate("ToR110-10a",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-10a",adx_arrow_m30,9, "Wingdings",adx_color_m30);
     ObjectSet("ToR110-10a", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-10a", OBJPROP_XDISTANCE, 745);
     ObjectSet("ToR110-10a", OBJPROP_YDISTANCE, 2); 
   if (adx_m30 > adx_1ago_m30)
   {
   //---- create text "increasing, decreasing"
   ObjectCreate("ToR110-10b",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-10b", " increasing ",9, "Lucida Console",adx_status_m30);
     ObjectSet("ToR110-10b", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-10b", OBJPROP_XDISTANCE, 672);
     ObjectSet("ToR110-10b", OBJPROP_YDISTANCE, 17); 
   }   
   if (adx_m30 < adx_1ago_m30)
   {
   ObjectCreate("ToR110-10b",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-10b", " decreasing ",9, "Lucida Console",adx_status_m30);
     ObjectSet("ToR110-10b", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-10b", OBJPROP_XDISTANCE, 672);
     ObjectSet("ToR110-10b", OBJPROP_YDISTANCE, 17); 
   }     
      
   if (Show_h1_ADX==true)
   {
   //----====>>>> create text "1 Hr: "
   ObjectCreate("ToR110-11",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-11","1 Hr:", 10, "Lucida Sans Regular", LightSteelBlue);
     ObjectSet("ToR110-11", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-11", OBJPROP_XDISTANCE, 760);
     ObjectSet("ToR110-11", OBJPROP_YDISTANCE, 2);
   //---- create 15 min value
   ObjectCreate("ToR110-12",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-12", " ADX "+StringSubstr(adx_value_h1,0,5)+" ",9, "Lucida Sans Regular",adx_color_h1);
     ObjectSet("ToR110-12", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-12", OBJPROP_XDISTANCE, 790);
     ObjectSet("ToR110-12", OBJPROP_YDISTANCE, 2);
   ObjectCreate("ToR110-12a",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-12a",adx_arrow_h1,9, "Wingdings",adx_color_h1);
     ObjectSet("ToR110-12a", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-12a", OBJPROP_XDISTANCE, 865);
     ObjectSet("ToR110-12a", OBJPROP_YDISTANCE, 2);
   if (adx_h1 > adx_1ago_h1)
   {
   //---- create text "increasing, decreasing"
   ObjectCreate("ToR110-12b",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-12b", " increasing ",9, "Lucida Console",adx_status_h1);
     ObjectSet("ToR110-12b", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-12b", OBJPROP_XDISTANCE, 792);
     ObjectSet("ToR110-12b", OBJPROP_YDISTANCE, 17); 
   }   
   if (adx_h1 < adx_1ago_h1)
   {
   ObjectCreate("ToR110-12b",OBJ_LABEL, WindowFind("ToR 1.10 ("+Symbol()+")"), 0, 0);
     ObjectSetText("ToR110-12b", " decreasing ",9, "Lucida Console",adx_status_h1);
     ObjectSet("ToR110-12b", OBJPROP_CORNER, 0);
     ObjectSet("ToR110-12b", OBJPROP_XDISTANCE, 792);
     ObjectSet("ToR110-12b", OBJPROP_YDISTANCE, 17); 
    }     
   }
   
// --- Beri sinyal di sini ---------------------------------------------------------
   if (Turn_on_Signal)
      {
         if (Signal_from_TF == 1)
            {
              if ((adx_m1 >= ADX_trend_level) && (di_p_m1 > di_m_m1) && Bars>alertBar)
                 {Alert("ADX Buy Signal on ",Symbol()," TF 1 minute");alertBar = Bars;prev=1;}

              if ((adx_m1 >= ADX_trend_level) && (di_p_m1 < di_m_m1) && Bars>alertBar)
                 {Alert("ADX SeLL Signal on ",Symbol()," TF 1 minute");alertBar = Bars;prev=1;}   
            } 
            
          if (Signal_from_TF == 5)
            {
              if ((adx_m1 >= ADX_trend_level) && (di_p_m1 > di_m_m1) && Bars>alertBar)
                 {Alert("ADX Buy Signal on ",Symbol()," TF 5 minutes");alertBar = Bars;prev=1;}

              if ((adx_m1 >= ADX_trend_level) && (di_p_m1 < di_m_m1) && Bars>alertBar)
                 {Alert("ADX SeLL Signal on ",Symbol()," TF 5 minutes");alertBar = Bars;prev=1;}   
            } 
            
          if (Signal_from_TF == 15)
            {
              if ((adx_m1 >= ADX_trend_level) && (di_p_m1 > di_m_m1) && Bars>alertBar)
                 {Alert("ADX Buy Signal on ",Symbol()," TF 15 minutes");alertBar = Bars;prev=1;}

              if ((adx_m1 >= ADX_trend_level) && (di_p_m1 < di_m_m1) && Bars>alertBar)
                 {Alert("ADX SeLL Signal on ",Symbol()," TF 15 minutes");alertBar = Bars;prev=1;}   
            } 
            
          if (Signal_from_TF == 30)
            {
              if ((adx_m1 >= ADX_trend_level) && (di_p_m1 > di_m_m1) && Bars>alertBar)
                 {Alert("ADX Buy Signal on ",Symbol()," TF 30 minutes");alertBar = Bars;prev=1;}

              if ((adx_m1 >= ADX_trend_level) && (di_p_m1 < di_m_m1) && Bars>alertBar)
                 {Alert("ADX SeLL Signal on ",Symbol()," TF 30 minutes");alertBar = Bars;prev=1;}   
            }   
            
          if (Signal_from_TF == 60)
            {
              if ((adx_m1 >= ADX_trend_level) && (di_p_m1 > di_m_m1) && Bars>alertBar)
                 {Alert("ADX Buy Signal on ",Symbol()," TF 60 minutes");alertBar = Bars;prev=1;}

              if ((adx_m1 >= ADX_trend_level) && (di_p_m1 < di_m_m1) && Bars>alertBar)
                 {Alert("ADX SeLL Signal on ",Symbol()," TF 60 minutes");alertBar = Bars;prev=1;}   
            }     
      }
// ---------------------------------------------------------------------------------    

   return(0);
  }
//+------------------------------------------------------------------+